//
//  OPGlobals.h
//  OnePasswordOSX
//
//  Created by Roustem Karimov on 2012-09-14.
//  Copyright (c) 2012 AgileBits Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface OPGlobals : NSObject

+ (OPGlobals *)sharedGlobals;

#if !TARGET_OS_IPHONE
- (NSString *)securityApplicationGroupIdentifier;
- (NSURL *)containerURLForSecurityApplicationGroupIdentifier;

// This method can return a different URL depending on which build is running.
- (NSURL *)applicationGroupDirectory;

// These methods will return subpaths of the container URL for Security Application Group Identifier.
- (NSURL *)applicationGroupSharedMASReceiptDirectory;
- (NSURL *)applicationGroupSharedMASReceiptURLForMachineGUID:(NSString *)machineGUID;
- (NSURL *)applicationGroupLicenseFileURL;

// To specifically go after unsandboxed locations
- (NSURL *)legacyOtherVersionApplicationDataDirectory;
- (NSURL *)legacyUnsandboxed1Password4ApplicationLibraryDirectory;
- (NSURL *)legacyUnsandboxed1Password4AppStoreReceiptBackupURL;
- (NSURL *)legacyUnsandboxed1Password4LicenseFileURL;
- (NSURL *)legacyUnsandboxed1Password4SystemLicenseFileURL;

- (NSURL *)legacyWebStoreApplicationDataDirectory;
- (NSURL *)legacyMacAppStoreApplicationDataDirectory;
- (NSURL *)legacyBackupsDirectory;

- (NSURL *)spotlightMetadataDirectory;
- (NSURL *)oldAttachmentsCacheDirectory;

#endif

- (NSURL *)watchtowerDirectory;

- (NSURL *)applicationReplicasDirectory;
- (NSURL *)applicationDocumentsDirectory;
- (NSURL *)applicationLibraryDirectory;
- (NSURL *)applicationDataDirectory;
- (NSURL *)applicationCachesDirectory;
- (NSURL *)attachmentCacheDirectoryCreateIfNeeded:(BOOL)createIfNotExists;
- (NSURL *)backupsDirectory;

- (NSURL *)defaultDatabaseURL;
- (NSURL *)defaultB5DatabaseURL;
- (NSURL *)imageCacheDirectory;

- (void)createApplicationDataParentDirectory;
- (void)createApplicationDataDirectory;

- (void)resetApplicationSettings;
- (void)preserveApplicationSettings;
- (void)restoreApplicationSettings;

- (void)preserveApplicationCookies;
- (void)restoreApplicationCookies;

@end

@interface OPGlobals (B5Resources)

- (NSURL *)b5DownloadCacheAssetsDirectory;
- (NSURL *)b5UploadCacheAssetsDirectory;
- (NSURL *)b5ResourceCacheAssetsDirectoryForAccountUUID:(NSString *)accountUUID;
- (NSURL *)b5DownloadResourcesForAccountUUID:(NSString *)accountUUID profileUUID:(NSString *)profileUUID;
- (NSURL *)b5PendingFileUploadDirectoryAccountUUID:(NSString *)accountUUID profileUUID:(NSString *)profileUUID;
- (BOOL)deleteB5ResourceCacheAssetsDirectoryForAccountUUID:(NSString *)accountUUID profileUUID:(NSString *)profileUUID;

@end
